attribute vec4 position;
varying vec2 tc;
uniform int flip; 

void main()
{	
	gl_Position = vec4(position.xy, 0.0, 1.0);
	tc = (position.xy+1.0)/2.0;
	
	if (flip==1)
		tc.y = 1.0-tc.y;
}	

//FRAGMENT

#version 120
varying vec2 tc; 
uniform sampler2D Texture0; 
uniform sampler2D Texture1; 
uniform sampler2D Texture2;
uniform sampler2D Texture3;
uniform sampler2D Texture4;
uniform sampler2D Texture5;
uniform float tracks[64];
uniform float t;

// no need for gamma adjustments..
vec3 gammaColor(vec3 x) {
	x = max(vec3(0.0f), x-0.004);
	return (x*(6.2*x+0.5))/(x*(6.2*x+1.7)+0.06);
}


vec4 getSaturation(vec4 pixel, float Saturation)
{
   float saturation = Saturation; 
   
   pixel.rgb = mix(pixel.rgb, vec3(length(pixel.rgb)), saturation); 
   return pixel; 
}


vec4 getContrast(vec4 pixel, float Contrast)
{
   float contrast = Contrast;
   pixel.rgb *= contrast;  
   return pixel; 
}


vec4 getColorDistort(vec4 pixel, float ColorDistort)
{
   float cd = ColorDistort;
  pixel.rgb = fract(pixel.rgb-cd); 
   return pixel; 
}


vec4 getHue(vec4 pixel,float Hue)
{
   float hue = Hue;
  // pixel.rgb = pixel.rgb*normalize(pixel.rgb); 
   return pixel; 
}


float A = 0.15;
float B = 0.50;
float C = 0.10;
float D = 0.20; 
float E = 0.02;
float F = 0.30; 
float W = 10.2; 

float ExposureBias = 8.0; 

vec4 Uncharted2Tonemap(vec4 c) {
	vec3 x = vec3(c.xyz);
	return vec4( ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F, 1.0);
}

void main(void)
{   

	
	vec4 p = texture2D(Texture0, tc);
	vec4 a = texture2D(Texture3, tc)+texture2D(Texture2, tc);; 
	vec4 c = .5+.5*texture2D(Texture4, tc);
	//vec4 b = texture2D(Texture3, tc); 

	vec2 tcadd = 7.0*tc+t+943.0*sin(t*232+sin(t*3343)+cos(t*23+t))+34.f*cos(t+t)+tc*t;
	vec4 b = texture2D(Texture5, tcadd); 
	//vec4 c = max(vec4(0.f), texture2D(Texture4, tc)-.20);

	p = ((a)*.25+p);
//	p *= 1.0-pow(vec4(c.r*.5+c.g*.5+c.b*.25), vec4(.60));  ///exprimental
	
	vec4 toned = Uncharted2Tonemap(p*ExposureBias);
	vec4 white_scale = Uncharted2Tonemap( vec4(W) );
	vec4 color = toned/white_scale; 
	gl_FragColor = clamp(color, vec4(0.0), vec4(1.0));  // SRGB_FRAMEBUFFER does the gamma correction
	//gl_FragColor *= gl_FragColor;

	vec4 v = 1.0-clamp( (texture2D(Texture4, tc)-.25), 0., 1.); 
	//gl_FragColor *= v*v;//vec4(pow(v.r*v.g*v.b, 1.0));
	gl_FragColor.a = 1.0;


	gl_FragColor += vec4(tracks[35]);

	vec4 pfix = getContrast(gl_FragColor, c*1.5+b.r*.125);

	gl_FragColor = pfix;

	//gl_FragColor = v;
	/*
	vec4 a1 = texture2D(Texture2, tc, 1);
	vec4 a2 = texture2D(Texture2, tc, 2); 
	vec4 a3 = texture2D(Texture2, tc, 3);
	vec4 a4 = texture2D(Texture2, tc, 4);
	vec4 a5 = texture2D(Texture2, tc, 5);


	gl_FragColor = (a+a1+a2+a3+a4+a5)/2.0;
	gl_FragColor = a5;
	*/
//	gl_FragColor = vec4(1.0)-(texture2D(Texture4, tc)-.5);
//	gl_FragColor = texture2D(Texture3, tc)+texture2D(Texture2, tc);

	//gl_FragColor = getContrast(color, 3.3);
	//gl_FragColor = getColorDistort(clamp(color, vec4(0.0), vec4(.90)) , 0.0);
}
